/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class FBCachedBlob
implements Blob {
    static final byte[] BYTES_NULL_VALUE = null;
    static final InputStream STREAM_NULL_VALUE = null;
    private byte[] blobData;

    public FBCachedBlob(byte[] data) {
        this.blobData = data;
    }

    public InputStream getBinaryStream() throws SQLException {
        if (this.blobData == null) {
            return null;
        }
        return new ByteArrayInputStream(this.blobData);
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (this.blobData == null) {
            return null;
        }
        byte[] result = new byte[length];
        System.arraycopy(this.blobData, (int)pos - 1, result, 0, length);
        return result;
    }

    public long length() throws SQLException {
        if (this.blobData == null) {
            return -1L;
        }
        return this.blobData.length;
    }

    public long position(Blob pattern, long start) throws SQLException {
        throw new SQLException("Not yet implemented.");
    }

    public long position(byte[] pattern, long start) throws SQLException {
        throw new SQLException("Not yet implemented.");
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new SQLException("Blob in auto-commit mode is read-only.");
    }

    public int setBytes(long l, byte[] abyte0) throws SQLException {
        throw new SQLException("Blob in auto-commit mode is read-only.");
    }

    public int setBytes(long l, byte[] abyte0, int i, int j) throws SQLException {
        throw new SQLException("Blob in auto-commit mode is read-only.");
    }

    public void truncate(long length) throws SQLException {
        throw new SQLException("Not yet implemented.");
    }
}

