/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tree
extends Composite {
    int modelHandle;
    int columnHandle;
    int checkRenderer;
    int pixbufRenderer;
    int textRenderer;
    TreeItem[] items;
    ImageList imageList;
    static final int TEXT_COLUMN = 0;
    static final int PIXBUF_COLUMN = 1;
    static final int FOREGROUND_COLUMN = 2;
    static final int BACKGROUND_COLUMN = 3;
    static final int FONT_COLUMN = 4;
    static final int ID_COLUMN = 5;
    static final int CHECKED_COLUMN = 6;
    static final int GRAYED_COLUMN = 7;

    public Tree(Composite parent, int style) {
        super(parent, Tree.checkStyle(style));
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style |= 0x300, 4, 2, 0, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        Point size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        size.x = trim.width;
        size.y = trim.height;
        return size;
    }

    void createHandle(int index) {
        this.state |= 8;
        this.fixedHandle = OS.gtk_fixed_new();
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window((int)this.fixedHandle, (boolean)true);
        this.scrolledHandle = OS.gtk_scrolled_window_new((int)0, (int)0);
        if (this.scrolledHandle == 0) {
            this.error(2);
        }
        int[] types = new int[(this.style & 0x20) != 0 ? 8 : 6];
        types[0] = OS.G_TYPE_STRING();
        types[1] = OS.GDK_TYPE_PIXBUF();
        types[2] = OS.GDK_TYPE_COLOR();
        types[3] = OS.GDK_TYPE_COLOR();
        types[4] = OS.PANGO_TYPE_FONT_DESCRIPTION();
        types[5] = OS.G_TYPE_INT();
        if ((this.style & 0x20) != 0) {
            types[6] = OS.G_TYPE_BOOLEAN();
            types[7] = OS.G_TYPE_BOOLEAN();
        }
        this.modelHandle = OS.gtk_tree_store_newv((int)types.length, (int[])types);
        if (this.modelHandle == 0) {
            this.error(2);
        }
        this.handle = OS.gtk_tree_view_new_with_model((int)this.modelHandle);
        if (this.handle == 0) {
            this.error(2);
        }
        this.columnHandle = OS.gtk_tree_view_column_new();
        if (this.columnHandle == 0) {
            this.error(2);
        }
        OS.g_object_ref((int)this.columnHandle);
        if ((this.style & 0x20) != 0) {
            this.checkRenderer = OS.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0) {
                this.error(2);
            }
            OS.gtk_tree_view_column_pack_start((int)this.columnHandle, (int)this.checkRenderer, (boolean)false);
            OS.gtk_tree_view_column_add_attribute((int)this.columnHandle, (int)this.checkRenderer, (String)"active", (int)6);
            if (OS.gtk_major_version() > 2 || OS.gtk_major_version() == 2 && OS.gtk_minor_version() >= 2) {
                OS.gtk_tree_view_column_add_attribute((int)this.columnHandle, (int)this.checkRenderer, (String)"inconsistent", (int)7);
            }
        }
        this.pixbufRenderer = OS.gtk_cell_renderer_pixbuf_new();
        if (this.pixbufRenderer == 0) {
            this.error(2);
        }
        OS.gtk_tree_view_column_pack_start((int)this.columnHandle, (int)this.pixbufRenderer, (boolean)false);
        OS.gtk_tree_view_column_add_attribute((int)this.columnHandle, (int)this.pixbufRenderer, (String)"pixbuf", (int)1);
        if ((this.style & 0x20) != 0) {
            OS.g_object_set((int)this.pixbufRenderer, (byte[])OS.mode, (int)1, (int)0);
        }
        this.textRenderer = OS.gtk_cell_renderer_text_new();
        if (this.textRenderer == 0) {
            this.error(2);
        }
        OS.gtk_tree_view_column_pack_start((int)this.columnHandle, (int)this.textRenderer, (boolean)true);
        OS.gtk_tree_view_column_add_attribute((int)this.columnHandle, (int)this.textRenderer, (String)"text", (int)0);
        OS.gtk_tree_view_column_add_attribute((int)this.columnHandle, (int)this.textRenderer, (String)"foreground-gdk", (int)2);
        OS.gtk_tree_view_column_add_attribute((int)this.columnHandle, (int)this.textRenderer, (String)"background-gdk", (int)3);
        OS.gtk_tree_view_column_add_attribute((int)this.columnHandle, (int)this.textRenderer, (String)"font-desc", (int)4);
        int parentHandle = this.parent.parentingHandle();
        OS.gtk_container_add((int)parentHandle, (int)this.fixedHandle);
        OS.gtk_container_add((int)this.fixedHandle, (int)this.scrolledHandle);
        OS.gtk_container_add((int)this.scrolledHandle, (int)this.handle);
        OS.gtk_widget_show((int)this.fixedHandle);
        OS.gtk_widget_show((int)this.scrolledHandle);
        OS.gtk_widget_show((int)this.handle);
        int mode = (this.style & 2) != 0 ? 3 : 2;
        int selectionHandle = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.gtk_tree_selection_set_mode((int)selectionHandle, (int)mode);
        OS.gtk_tree_view_set_headers_visible((int)this.handle, (boolean)false);
        int hsp = (this.style & 0x100) != 0 ? 1 : 2;
        int vsp = (this.style & 0x200) != 0 ? 1 : 2;
        OS.gtk_scrolled_window_set_policy((int)this.scrolledHandle, (int)hsp, (int)vsp);
        if ((this.style & 0x800) != 0) {
            OS.gtk_scrolled_window_set_shadow_type((int)this.scrolledHandle, (int)3);
        }
    }

    void createItem(TreeItem item, int iter, int index) {
        int column = OS.gtk_tree_view_get_column((int)this.handle, (int)0);
        if (column == 0) {
            OS.gtk_tree_view_insert_column((int)this.handle, (int)this.columnHandle, (int)0);
        }
        int count = OS.gtk_tree_model_iter_n_children((int)this.modelHandle, (int)iter);
        if (index == -1) {
            index = count;
        }
        if (index < 0 || index > count) {
            this.error(6);
        }
        int id = 0;
        while (id < this.items.length && this.items[id] != null) {
            ++id;
        }
        if (id == this.items.length) {
            TreeItem[] newItems = new TreeItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        item.handle = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
        if (item.handle == 0) {
            this.error(2);
        }
        if (index == count) {
            OS.gtk_tree_store_append((int)this.modelHandle, (int)item.handle, (int)iter);
        } else {
            OS.gtk_tree_store_insert((int)this.modelHandle, (int)item.handle, (int)iter, (int)index);
        }
        OS.gtk_tree_store_set((int)this.modelHandle, (int)item.handle, (int)5, (int)id, (int)-1);
        this.items[id] = item;
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.items = new TreeItem[4];
    }

    GdkColor defaultBackground() {
        return this.display.COLOR_LIST_BACKGROUND;
    }

    GdkColor defaultForeground() {
        return this.display.COLOR_LIST_FOREGROUND;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(OS.gtk_tree_view_get_selection((int)this.handle));
        if (this.checkRenderer != 0) {
            this.display.removeWidget(this.checkRenderer);
        }
    }

    public void deselectAll() {
        this.checkWidget();
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        OS.gtk_tree_selection_unselect_all((int)selection);
        OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
    }

    void destroyItem(TreeItem item) {
        if (OS.gtk_major_version() == 2 && OS.gtk_minor_version() == 0 && OS.gtk_micro_version() < 6) {
            TreeItem[] roots = this.getItems(0);
            int i = 0;
            while (i < roots.length) {
                if (item == roots[i]) {
                    item.setExpanded(false);
                    break;
                }
                ++i;
            }
        }
        int[] index = new int[1];
        this.releaseItems(item.getItems(), index);
        this.releaseItem(item, index);
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        OS.gtk_tree_store_remove((int)this.modelHandle, (int)item.handle);
        OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        int childCount = OS.gtk_tree_model_iter_n_children((int)this.modelHandle, (int)0);
        if (childCount == 0) {
            this.removeColumn();
        }
    }

    void destroyWidget() {
        if (OS.gtk_major_version() == 2 && OS.gtk_minor_version() == 0 && OS.gtk_micro_version() < 5) {
            while (OS.gtk_events_pending() != 0) {
                OS.gtk_main_iteration();
            }
        }
        super.destroyWidget();
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    TreeItem getFocusItem() {
        int[] path = new int[1];
        OS.gtk_tree_view_get_cursor((int)this.handle, (int[])path, null);
        if (path[0] == 0) {
            return null;
        }
        TreeItem item = null;
        int iter = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_get_iter((int)this.modelHandle, (int)iter, (int)path[0])) {
            int[] index = new int[1];
            OS.gtk_tree_model_get((int)this.modelHandle, (int)iter, (int)5, (int[])index, (int)-1);
            item = this.items[index[0]];
        }
        OS.g_free((int)iter);
        OS.gtk_tree_path_free((int)path[0]);
        return item;
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public TreeItem getItem(Point point) {
        this.checkWidget();
        int[] path = new int[1];
        OS.gtk_widget_realize((int)this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos((int)this.handle, (int)point.x, (int)point.y, (int[])path, null, null, null)) {
            return null;
        }
        if (path[0] == 0) {
            return null;
        }
        TreeItem item = null;
        int iter = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_get_iter((int)this.modelHandle, (int)iter, (int)path[0])) {
            boolean overExpander = false;
            if (OS.gtk_tree_model_iter_n_children((int)this.modelHandle, (int)iter) > 0) {
                int[] buffer = new int[1];
                GdkRectangle rect = new GdkRectangle();
                OS.gtk_tree_view_get_cell_area((int)this.handle, (int)path[0], (int)this.columnHandle, (GdkRectangle)rect);
                OS.gtk_widget_style_get((int)this.handle, (byte[])OS.expander_size, (int[])buffer, (int)0);
                int expanderSize = buffer[0] + 4;
                boolean bl = overExpander = rect.x - 1 <= point.x && point.x < rect.x + expanderSize;
            }
            if (!overExpander) {
                int[] index = new int[1];
                OS.gtk_tree_model_get((int)this.modelHandle, (int)iter, (int)5, (int[])index, (int)-1);
                item = this.items[index[0]];
            }
        }
        OS.g_free((int)iter);
        OS.gtk_tree_path_free((int)path[0]);
        return item;
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.gtk_tree_model_iter_n_children((int)this.modelHandle, (int)0);
    }

    public int getItemHeight() {
        this.checkWidget();
        int itemCount = OS.gtk_tree_model_iter_n_children((int)this.modelHandle, (int)0);
        if (itemCount == 0) {
            int[] w = new int[1];
            int[] h = new int[1];
            OS.gtk_tree_view_insert_column((int)this.handle, (int)this.columnHandle, (int)0);
            OS.gtk_tree_view_column_cell_get_size((int)this.columnHandle, null, null, null, (int[])w, (int[])h);
            OS.gtk_tree_view_remove_column((int)this.handle, (int)this.columnHandle);
            return h[0];
        }
        int iter = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_get_iter_first((int)this.modelHandle, (int)iter);
        int column = OS.gtk_tree_view_get_column((int)this.handle, (int)0);
        OS.gtk_tree_view_column_cell_set_cell_data((int)column, (int)this.modelHandle, (int)iter, (boolean)false, (boolean)false);
        int[] w = new int[1];
        int[] h = new int[1];
        OS.gtk_tree_view_column_cell_get_size((int)column, null, null, null, (int[])w, (int[])h);
        OS.g_free((int)iter);
        return h[0];
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        return this.getItems(0);
    }

    TreeItem[] getItems(int parent) {
        int length = OS.gtk_tree_model_iter_n_children((int)this.modelHandle, (int)parent);
        TreeItem[] result = new TreeItem[length];
        if (length == 0) {
            return result;
        }
        int i = 0;
        int[] index = new int[1];
        int iter = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
        boolean valid = OS.gtk_tree_model_iter_children((int)this.modelHandle, (int)iter, (int)parent);
        while (valid) {
            OS.gtk_tree_model_get((int)this.modelHandle, (int)iter, (int)5, (int[])index, (int)-1);
            result[i++] = this.items[index[0]];
            valid = OS.gtk_tree_model_iter_next((int)this.modelHandle, (int)iter);
        }
        OS.g_free((int)iter);
        return result;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    public TreeItem[] getSelection() {
        TreeItem[] result;
        this.checkWidget();
        if ((this.style & 2) != 0) {
            this.display.treeSelectionLength = 0;
            this.display.treeSelection = new int[this.items.length];
            int selection = OS.gtk_tree_view_get_selection((int)this.handle);
            OS.gtk_tree_selection_selected_foreach((int)selection, (int)this.display.treeSelectionProc, (int)this.handle);
            TreeItem[] result2 = new TreeItem[this.display.treeSelectionLength];
            int i = 0;
            while (i < result2.length) {
                result2[i] = this.items[this.display.treeSelection[i]];
                ++i;
            }
            return result2;
        }
        int iter = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        boolean hasSelection = OS.gtk_tree_selection_get_selected((int)selection, null, (int)iter);
        if (hasSelection) {
            int[] index = new int[1];
            OS.gtk_tree_model_get((int)this.modelHandle, (int)iter, (int)5, (int[])index, (int)-1);
            result = new TreeItem[]{this.items[index[0]]};
        } else {
            result = new TreeItem[]{};
        }
        OS.g_free((int)iter);
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        this.display.treeSelectionLength = 0;
        this.display.treeSelection = null;
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.gtk_tree_selection_selected_foreach((int)selection, (int)this.display.treeSelectionProc, (int)this.handle);
        return this.display.treeSelectionLength;
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        int[] path = new int[1];
        OS.gtk_widget_realize((int)this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos((int)this.handle, (int)1, (int)1, (int[])path, null, null, null)) {
            return null;
        }
        if (path[0] == 0) {
            return null;
        }
        TreeItem item = null;
        int iter = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_get_iter((int)this.modelHandle, (int)iter, (int)path[0])) {
            int[] index = new int[1];
            OS.gtk_tree_model_get((int)this.modelHandle, (int)iter, (int)5, (int[])index, (int)-1);
            item = this.items[index[0]];
        }
        OS.g_free((int)iter);
        OS.gtk_tree_path_free((int)path[0]);
        return item;
    }

    int gtk_changed(int widget) {
        TreeItem item = this.getFocusItem();
        if (item != null) {
            Event event = new Event();
            event.item = item;
            this.postEvent(13, event);
        }
        return 0;
    }

    int gtk_key_press_event(int widget, int eventPtr) {
        int result = super.gtk_key_press_event(widget, eventPtr);
        if (result != 0) {
            return result;
        }
        GdkEventKey keyEvent = new GdkEventKey();
        OS.memmove((GdkEventKey)keyEvent, (int)eventPtr, (int)GdkEventKey.sizeof);
        int key = keyEvent.keyval;
        switch (key) {
            case 65293: 
            case 65421: {
                Event event = new Event();
                event.item = this.getFocusItem();
                this.postEvent(14, event);
            }
        }
        return result;
    }

    int gtk_row_activated(int tree, int path, int column) {
        if (path == 0) {
            return 0;
        }
        TreeItem item = null;
        int iter = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_get_iter((int)this.modelHandle, (int)iter, (int)path)) {
            int[] index = new int[1];
            OS.gtk_tree_model_get((int)this.modelHandle, (int)iter, (int)5, (int[])index, (int)-1);
            item = this.items[index[0]];
        }
        OS.g_free((int)iter);
        Event event = new Event();
        event.item = item;
        this.postEvent(14, event);
        return 0;
    }

    int gtk_test_collapse_row(int tree, int iter, int path) {
        int[] index = new int[1];
        OS.gtk_tree_model_get((int)this.modelHandle, (int)iter, (int)5, (int[])index, (int)-1);
        Event event = new Event();
        event.item = this.items[index[0]];
        this.sendEvent(18, event);
        if (this.isDisposed()) {
            return 0;
        }
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)37);
        OS.gtk_tree_view_collapse_row((int)this.handle, (int)path);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)37);
        return 1;
    }

    int gtk_test_expand_row(int tree, int iter, int path) {
        int[] index = new int[1];
        OS.gtk_tree_model_get((int)this.modelHandle, (int)iter, (int)5, (int[])index, (int)-1);
        Event event = new Event();
        event.item = this.items[index[0]];
        this.sendEvent(17, event);
        if (this.isDisposed()) {
            return 0;
        }
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)38);
        OS.gtk_tree_view_expand_row((int)this.handle, (int)path, (boolean)false);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)38);
        return 1;
    }

    int gtk_toggled(int renderer, int pathStr) {
        int path = OS.gtk_tree_path_new_from_string((int)pathStr);
        if (path == 0) {
            return 0;
        }
        TreeItem item = null;
        int iter = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_get_iter((int)this.modelHandle, (int)iter, (int)path)) {
            int[] index = new int[1];
            OS.gtk_tree_model_get((int)this.modelHandle, (int)iter, (int)5, (int[])index, (int)-1);
            item = this.items[index[0]];
        }
        OS.g_free((int)iter);
        OS.gtk_tree_path_free((int)path);
        item.setChecked(!item.getChecked());
        Event event = new Event();
        event.detail = 32;
        event.item = item;
        this.postEvent(13, event);
        return 0;
    }

    int gtk_button_press_event(int widget, int event) {
        int selection;
        int[] path;
        int result = super.gtk_button_press_event(widget, event);
        if (result != 0) {
            return result;
        }
        if (!OS.GTK_WIDGET_HAS_FOCUS((int)this.handle)) {
            OS.gtk_widget_grab_focus((int)this.handle);
            if (this.isDisposed()) {
                return 0;
            }
        }
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove((GdkEventButton)gdkEvent, (int)event, (int)GdkEventButton.sizeof);
        int button = gdkEvent.button;
        if (button == 3 && gdkEvent.type == 4 && OS.gtk_tree_view_get_path_at_pos((int)this.handle, (int)((int)gdkEvent.x), (int)((int)gdkEvent.y), (int[])(path = new int[1]), null, null, null) && path[0] != 0) {
            selection = OS.gtk_tree_view_get_selection((int)this.handle);
            if (OS.gtk_tree_selection_path_is_selected((int)selection, (int)path[0])) {
                result = 1;
            }
            OS.gtk_tree_path_free((int)path[0]);
        }
        if ((this.style & 4) != 0 && this.getSelectionCount() == 0 && OS.gtk_tree_view_get_path_at_pos((int)this.handle, (int)((int)gdkEvent.x), (int)((int)gdkEvent.y), (int[])(path = new int[1]), null, null, null) && path[0] != 0) {
            selection = OS.gtk_tree_view_get_selection((int)this.handle);
            OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
            OS.gtk_tree_view_set_cursor((int)this.handle, (int)path[0], (int)0, (boolean)false);
            OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
            OS.gtk_tree_path_free((int)path[0]);
        }
        return result;
    }

    void hookEvents() {
        super.hookEvents();
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.g_signal_connect_after((int)selection, (byte[])OS.changed, (int)this.display.windowProc2, (int)4);
        OS.g_signal_connect((int)this.handle, (byte[])OS.row_activated, (int)this.display.windowProc4, (int)29);
        OS.g_signal_connect((int)this.handle, (byte[])OS.test_expand_row, (int)this.display.windowProc4, (int)38);
        OS.g_signal_connect((int)this.handle, (byte[])OS.test_collapse_row, (int)this.display.windowProc4, (int)37);
        if (this.checkRenderer != 0) {
            OS.g_signal_connect((int)this.checkRenderer, (byte[])OS.toggled, (int)this.display.windowProc3, (int)39);
        }
    }

    int paintWindow() {
        OS.gtk_widget_realize((int)this.handle);
        return OS.gtk_tree_view_get_bin_window((int)this.handle);
    }

    void register() {
        super.register();
        this.display.addWidget(OS.gtk_tree_view_get_selection((int)this.handle), this);
        if (this.checkRenderer != 0) {
            this.display.addWidget(this.checkRenderer, this);
        }
    }

    boolean releaseItem(TreeItem item, int[] index) {
        if (item.isDisposed()) {
            return false;
        }
        OS.gtk_tree_model_get((int)this.modelHandle, (int)item.handle, (int)5, (int[])index, (int)-1);
        this.items[index[0]] = null;
        return true;
    }

    void releaseItems(TreeItem[] nodes, int[] index) {
        int i = 0;
        while (i < nodes.length) {
            TreeItem item = nodes[i];
            TreeItem[] sons = item.getItems();
            if (sons.length != 0) {
                this.releaseItems(sons, index);
            }
            if (this.releaseItem(item, index)) {
                item.releaseResources();
            }
            ++i;
        }
    }

    void releaseWidget() {
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.releaseResources();
            }
            ++i;
        }
        this.items = null;
        super.releaseWidget();
        if (this.modelHandle != 0) {
            OS.g_object_unref((int)this.modelHandle);
        }
        this.modelHandle = 0;
        if (this.columnHandle != 0) {
            OS.g_object_unref((int)this.columnHandle);
        }
        this.columnHandle = 0;
        if (this.imageList != null) {
            this.imageList.dispose();
            this.imageList = null;
        }
    }

    public void removeAll() {
        this.checkWidget();
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.releaseResources();
            }
            ++i;
        }
        this.items = new TreeItem[4];
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        OS.gtk_tree_store_clear((int)this.modelHandle);
        OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        this.removeColumn();
    }

    void removeColumn() {
        int column = OS.gtk_tree_view_get_column((int)this.handle, (int)0);
        if (column == 0) {
            return;
        }
        OS.gtk_tree_view_remove_column((int)this.handle, (int)column);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, listener);
        this.eventTable.unhook(18, listener);
    }

    public void setInsertMark(TreeItem item, boolean before) {
        this.checkWidget();
        if (item == null) {
            OS.gtk_tree_view_unset_rows_drag_dest((int)this.handle);
            return;
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parent != this) {
            return;
        }
        Rectangle rect = item.getBounds();
        int[] path = new int[1];
        OS.gtk_widget_realize((int)this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos((int)this.handle, (int)rect.x, (int)rect.y, (int[])path, null, null, null)) {
            return;
        }
        if (path[0] == 0) {
            return;
        }
        int position = before ? 0 : 1;
        OS.gtk_tree_view_set_drag_dest_row((int)this.handle, (int)path[0], (int)position);
        OS.gtk_tree_path_free((int)path[0]);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        OS.gtk_tree_selection_select_all((int)OS.gtk_tree_view_get_selection((int)this.handle));
        OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
    }

    void setBackgroundColor(GdkColor color) {
        super.setBackgroundColor(color);
        OS.gtk_widget_modify_base((int)this.handle, (int)0, (GdkColor)color);
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean result = super.setBounds(x, y, width, height, move, resize);
        OS.gtk_widget_realize((int)this.handle);
        return result;
    }

    void setForegroundColor(GdkColor color) {
        super.setForegroundColor(color);
        OS.gtk_widget_modify_text((int)this.handle, (int)0, (GdkColor)color);
    }

    public void setSelection(TreeItem[] items) {
        int length;
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        if ((length = items.length) == 0 || (this.style & 4) != 0 && length > 1) {
            this.deselectAll();
            return;
        }
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        OS.gtk_tree_selection_unselect_all((int)selection);
        boolean first = true;
        int i = 0;
        while (i < length) {
            TreeItem item = items[i];
            if (item != null) {
                if (item.isDisposed()) break;
                if (item.parent == this) {
                    int path = OS.gtk_tree_model_get_path((int)this.modelHandle, (int)item.handle);
                    this.showItem(path, first);
                    OS.gtk_tree_selection_select_iter((int)selection, (int)item.handle);
                    if ((this.style & 4) != 0) {
                        OS.gtk_tree_view_set_cursor((int)this.handle, (int)path, (int)0, (boolean)false);
                    }
                    OS.gtk_tree_path_free((int)path);
                    first = false;
                }
            }
            ++i;
        }
        OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
    }

    public void setTopItem(TreeItem item) {
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parent != this) {
            return;
        }
        int path = OS.gtk_tree_model_get_path((int)this.modelHandle, (int)item.handle);
        this.showItem(path, false);
        OS.gtk_tree_view_scroll_to_cell((int)this.handle, (int)path, (int)0, (boolean)true, (float)0.0f, (float)0.0f);
        OS.gtk_tree_path_free((int)path);
    }

    public void showSelection() {
        this.checkWidget();
        TreeItem[] items = this.getSelection();
        if (items.length != 0 && items[0] != null) {
            this.showItem(items[0]);
        }
    }

    void showItem(int path, boolean scroll) {
        int depth = OS.gtk_tree_path_get_depth((int)path);
        if (depth > 1) {
            int[] indices = new int[depth - 1];
            int indicesPtr = OS.gtk_tree_path_get_indices((int)path);
            OS.memmove((int[])indices, (int)indicesPtr, (int)(indices.length * 4));
            int tempPath = OS.gtk_tree_path_new();
            int i = 0;
            while (i < indices.length) {
                OS.gtk_tree_path_append_index((int)tempPath, (int)indices[i]);
                OS.gtk_tree_view_expand_row((int)this.handle, (int)tempPath, (boolean)false);
                ++i;
            }
            OS.gtk_tree_path_free((int)tempPath);
        }
        if (scroll) {
            boolean isHidden;
            GdkRectangle rect = new GdkRectangle();
            OS.gtk_widget_realize((int)this.handle);
            OS.gtk_tree_view_get_cell_area((int)this.handle, (int)path, (int)0, (GdkRectangle)rect);
            boolean bl = isHidden = rect.y == 0 && rect.height == 0;
            if (!isHidden) {
                int[] tx = new int[1];
                int[] ty = new int[1];
                OS.gtk_tree_view_widget_to_tree_coords((int)this.handle, (int)rect.x, (int)rect.y, (int[])tx, (int[])ty);
                rect.y = ty[0];
                GdkRectangle visRect = new GdkRectangle();
                OS.gtk_tree_view_get_visible_rect((int)this.handle, (GdkRectangle)visRect);
                if (rect.y < visRect.y || rect.y + rect.height > visRect.y + visRect.height) {
                    isHidden = true;
                }
            }
            if (isHidden) {
                OS.gtk_tree_view_scroll_to_cell((int)this.handle, (int)path, (int)0, (depth != 1 ? 1 : 0) != 0, (float)0.5f, (float)0.0f);
            }
        }
    }

    public void showItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parent != this) {
            return;
        }
        int path = OS.gtk_tree_model_get_path((int)this.modelHandle, (int)item.handle);
        this.showItem(path, true);
        OS.gtk_tree_path_free((int)path);
    }

    int treeSelectionProc(int model, int path, int iter, int[] selection, int length) {
        if (selection != null) {
            int[] index = new int[1];
            OS.gtk_tree_model_get((int)this.modelHandle, (int)iter, (int)5, (int[])index, (int)-1);
            selection[length] = index[0];
        }
        return 0;
    }
}

