#!/bin/sh
ORACLE_SID=ORCL
export ORACLE_SID

/usr/oracle/bin/svrmgrl << EOF
spool ./02crdb.log
connect internal
@/usr/oracle/rdbms/admin/catalog.sql;

CREATE ROLLBACK SEGMENT r0 TABLESPACE SYSTEM
STORAGE (INITIAL 16K NEXT 16K MINEXTENTS 2 MAXEXTENTS 20);
ALTER ROLLBACK SEGMENT r0 ONLINE;

REM ************** TABLESPACE FOR ROLLBACK *****************
CREATE TABLESPACE RBS01 DATAFILE '/usr/oracle/orcl/data/rbs01.dbf' SIZE 10M REUSE 
DEFAULT STORAGE ( INITIAL 128K NEXT 128K MINEXTENTS 2 MAXEXTENTS UNLIMITED  PCTINCREASE 0);

CREATE TABLESPACE RBS02 DATAFILE '/usr/oracle/orcl/data/rbs02.dbf' SIZE 10M REUSE 
DEFAULT STORAGE ( INITIAL 128K NEXT 128K MINEXTENTS 2 MAXEXTENTS UNLIMITED  PCTINCREASE 0);

CREATE TABLESPACE RBS03 DATAFILE '/usr/oracle/orcl/data/rbs03.dbf' SIZE 10M REUSE 
DEFAULT STORAGE ( INITIAL 128K NEXT 128K MINEXTENTS 2 MAXEXTENTS UNLIMITED  PCTINCREASE 0);

CREATE TABLESPACE RBS04 DATAFILE '/usr/oracle/orcl/data/rbs04.dbf' SIZE 10M REUSE 
DEFAULT STORAGE ( INITIAL 128K NEXT 128K MINEXTENTS 2 MAXEXTENTS UNLIMITED  PCTINCREASE 0);

REM ************** TABLESPACE FOR TEMPORARY *****************
CREATE TABLESPACE TEMP DATAFILE
  '/usr/oracle/orcl/data/temp.dbf' SIZE 10M REUSE
DEFAULT STORAGE ( INITIAL 256K NEXT 256K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0) TEMPORARY;

REM **** Creating four rollback segments ****************
CREATE ROLLBACK SEGMENT rbs01 TABLESPACE RBS01
STORAGE  (INITIAL 128K NEXT 128K OPTIMAL 1280K MINEXTENTS 2 MAXEXTENTS UNLIMITED);
CREATE ROLLBACK SEGMENT rbs02 TABLESPACE RBS02
STORAGE  (INITIAL 128K NEXT 128K OPTIMAL 1280K MINEXTENTS 2 MAXEXTENTS UNLIMITED);
CREATE ROLLBACK SEGMENT rbs03 TABLESPACE RBS03
STORAGE  (INITIAL 128K NEXT 128K OPTIMAL 1280K MINEXTENTS 2 MAXEXTENTS UNLIMITED);
CREATE ROLLBACK SEGMENT rbs04 TABLESPACE RBS04
STORAGE  (INITIAL 128K NEXT 128K OPTIMAL 1280K MINEXTENTS 2 MAXEXTENTS UNLIMITED);
ALTER ROLLBACK SEGMENT rbs01 ONLINE;
ALTER ROLLBACK SEGMENT rbs02 ONLINE;
ALTER ROLLBACK SEGMENT rbs03 ONLINE;
ALTER ROLLBACK SEGMENT rbs04 ONLINE;
ALTER ROLLBACK SEGMENT r0 OFFLINE;
DROP ROLLBACK SEGMENT r0;

REM **** SYS and SYSTEM users ****************
alter user sys temporary tablespace TEMP;
alter user system temporary tablespace TEMP;
disconnect
spool off
exit

EOF

